// Copyright 2006 Adobe Macromedia Software LLC and its licensors. All rights reserved.
//*************** GLOBALS VARS *****************
//******************* BEHAVIOR FUNCTION **********************
//******************* API **********************

//Can be used with any tag and any event

function canAcceptBehavior(){
  return true;
}


//Returns a Javascript function to be inserted in HTML head with script tags.

function behaviorFunction()
{
  return "Spry.Data.XMLDataSet";
}

//Returns a dummy function call to inform Dreamweaver the type of certain behavior
//call arguments. This information is used by DW to fixup behavior args when the
//document is moved or changed.
//
//It is passed an actual function call string generated by applyBehavior(), which
//may have a variable list of arguments, and this should return a matching mask.
//
//The return values are:
//  URL     : argument could be a file path, which DW will update during Save As...
//  DEP     : argument is a dependent file
//  REL     : argument is a "Related File" (special case of dependent file)
//  NS4.0ref: arg is an object ref that may be changed by Convert Tables to Layers
//  IE4.0ref: arg is an object ref that may be changed by Convert Tables to Layers
//  other...: argument is ignored
function identifyBehaviorArguments(fnCallStr) 
{
  //default the arg list to 3 params
  var argList = "REL,other,other";
  var argArray;
  argArray = dwscripts.extractArgs(fnCallStr);
  if (argArray.length == 2) 
  {
	//shorten it for 2 params
    argList = "REL,other";
  }
  return argList;
}

